
/* ************************************************************************** */
/*  Quan`s RS232.c code modified to use for file transfers to the Fluke       */
/*  12-23-91   R. Christopherson                                              */
/* ************************************************************************** */


/* #include     <curses.h>      */
#include        <sgtty.h>
/* #include     <sysent.h>      */ /* C++ Lib */
#include        <ctype.h>
/* #include     <libc.h>        */ /* C++ Lib */
#include        <time.h>
#include        <sys/param.h>
#include <stdio.h>;

#define comLF   10
#define comCR   13
#define comGRT  '>'

#define comSOH  1
#define comSTRINGLEN 1000000
#define MAX_TIME 2600              /* 3 seconds     ------------------ */
#define COMMAND 3
#define DATA_IN 2                       /* ReadComString() returns  ------ */
#define TIMED_OUT 1                     /*    "    "    "     "            */
#define NO_DATA 0                       /*    "    "    "     "            */

#define TRUE 1
#define FALSE 0

/* READ COM port file descriptor        */
FILE *ReadCom;
/* WRITE COM port file descriptor       */
FILE *WriteCom;

/* Malloc buffer to store message       */
char *gDataBuff;
char *portptr;
char *inputBuff;

int gOldComFlags;

static char Ascii_char[] = {124,47,45,92};

int InitComPort();
int TermComPort();
int ReadComString();
int ReadComPort();
void check_xon();
int WriteComString();
int WriteString();
int ComReady();
int dbGetDebugLevel();

/* ******************************************************************************* */
/*                        INITIALIZE RS232 PORT                                    */
/* ******************************************************************************* */

int InitComPort(portptr)
char *portptr;
{
        struct sgttyb portStruct;
     /*  long seconds;                                            */
        /* Allocate enough buffer to store data                       */
        /* gDataBuff = new char[comSTRINGLEN];     */  /*  C++        */
        /* gDataBuff[0] = '\0';                    */

        if ((WriteCom  = fopen(portptr,"w")) == NULL)
        {
                printf("\nPort '%s' can't be accessed for WRITING at ",portptr);
                printf("this time...Aborting!!\n");
                return(FALSE);
        }
        if ((ReadCom   = fopen(portptr,"r")) == NULL)
        {
                printf("\nPort '%s' can't be accessed for READING at ",portptr);
                printf("this time...Aborting!!\n");
                return(FALSE);
        }

        ioctl(fileno(ReadCom),TIOCGETP,&portStruct);

        gOldComFlags = portStruct.sg_flags;

        /* configure to RAW and no echo                                */
        portStruct.sg_flags |= RAW;
        portStruct.sg_flags &= (0xffffffff ^ ECHO);
/*portStruct.sg_flags &= ~(XON | XOFF)*/;

        ioctl(fileno(ReadCom),TIOCSETP,&portStruct);   /* set the port */

        return(TRUE);

}

/* ******************************************************************************** */
/*                      TERMINATE THE COM PORT                                      */
/* ******************************************************************************** */

int TermComPort()
{
        struct sgttyb portStruct;

       /*       printf("TermComPort")*/;

        /* get the current port status of the com port selected           */
        ioctl(fileno(ReadCom),TIOCGETP,&portStruct);

        /* restore the flags variable                                     */
        portStruct.sg_flags =  gOldComFlags;
        ioctl(fileno(ReadCom),TIOCSETP,&portStruct);

        /* close the com read and write ports                             */
        fclose(ReadCom);
        fclose(WriteCom);

        printf("\nClosed RS232 port..\n");


        /* delete gDataBuff; */  /* C++ */

        return(TRUE);
}

/* ******************************************************************************** */
/*                    READ DATA COMING INTO THE COM PORT (Received)                 */
/* ******************************************************************************** */

int ReadComString(inputBuff)
char *inputBuff;
{
        int     index,temp,count;
        char    ch;
        int    timeout, char_count;
        char    cntrl_Q[5];
        char    cntrl_S[5];

        /*printf("ReadComString\n"); */   /*    */
        /*printf("Maxtime = %d",MAX_TIME)*/;
        cntrl_Q[0] = 17;
        cntrl_Q[1] = '\0';
        /* cntrl_Q[2] = '\0';      */
        cntrl_S[0] = 19;
        cntrl_S[1] = '\0';
        /* cntrl_S[2] = '\0';      */

        index = 0;
        inputBuff[0] = '\0';
        timeout = 0;
        char_count = 0;
        count = 0;
        temp = 0;

        temp = WriteString(cntrl_Q);      /* allow Fluke to continue sending  */

        while(1)
        {
                if ((count = ComReady()) < 1)
                {
                        timeout++;
                        if (timeout > MAX_TIME)
                        {
                                /* temp = WriteString(cntrl_Q);*/ /*Fluke continue   */

                                /* printf("<Waiting for RS232 Input>\n");       */
                                if (inputBuff[0] == '\0')
                                        {
                                         printf("<Waiting for RS232 Input - TIMED OUT>\n");
                                         return (TIMED_OUT);
                                        }
                                inputBuff[index++] = '\0';
                                printf("<Waiting for RS232 Input - Returned DATA_IN>\n");
                                return (DATA_IN);
                        }       /* -- END IF timeout > MAX_TIME ----- */
                         /*printf("\r*%d",timeout);     */ /*  */
                        usleep(800);
                        /* continue;       */
                }               /* -- END IF ComReady != TRUE  ------ */


                else
                {
                /*temp = WriteString(cntrl_S);*/ /*Halt Fluke until buffers are empty*/
                temp = WriteString(cntrl_S);/*Halt Fluke until buffers are empty*/
              /*  printf("Count = %d , Index = %d\n",count,index)*/;

                while (count > 0)              /* Read in data buffers.            */
                {
                /* printf("Before read\n");          */
                if (read(fileno(ReadCom),&ch,1) > 0)
                        {
                       /* printf("After Read - Before inputBuff\n");        */
                        inputBuff[index++] = ch;
                                        /*  printf("%c",ch);*/    /* */
                        if (index == 1)
                                printf("\nReading Data from RS232 port.\n");
                        if (ch == 8)                    /*                */
                                {
                                        inputBuff[0] = '\0';
                                        printf("Received '8' from Fluke\n");    /* */
                                        WriteString(cntrl_Q);
                                        return(COMMAND);  /* Fluke command */
                                }        /* END IF (inputBuff == 8)       */
                        count--;
                        }               /* END IF (read(fileno -----)    */
                else
                        {
                         printf("Count: %d Failed Read\n",count);
                         count--;
                        }

                }               /* --- END WHILE (count >0)  ----------- */

                /* temp = WriteString(cntrl_Q);    */
             /*   printf("\nBefore Write cntrl_Q\n")*/;
                temp = WriteString(cntrl_Q); /* allow Fluke to continue sending  */
             /*   printf("OUt of count loop : %d\n",index)*/;
                timeout = 0;
                usleep(5000);
                }       /* -----------END IF ((count = ComReady < 1)) -------------  */

        };      /* ----------------- END WHILE (1)     ---------------------------- */

        printf("Something wrong- exited ReadCom\n");
        return (NO_DATA);
}

/* ******************************************************************************** */
/*                    READ DATA COMING INTO THE COM PORT (Received)                 */
/*                    (Short timeout for file Upload to Fluke 9100)                 */
/* ******************************************************************************** */

int ReadComPort(inputBuff)
char *inputBuff;
{
        int     index,count;
        char    ch;
        int maxtime = 500;
        int    timeout, temp;
        char    cntrl_Q[5];
        char    cntrl_S[5];

        /*printf("ReadComString\n"); */   /*    */
        /*printf("Maxtime = %d",MAX_TIME)*/;
        index = 0;
        inputBuff[0] = '\0';
        timeout = 0;
        count = 0;
        maxtime = 500;
        cntrl_Q[0] = 17;
        cntrl_Q[1] = '\0';
        cntrl_S[0] = 19;
        cntrl_S[1] = '\0';

        temp = WriteString(cntrl_Q);      /* allow Fluke to continue sending  */
        while(1)
        {
                if ((count = ComReady()) < 1)
                {
                        timeout++;
                                                /* printf("%d ",timeout); */ /*   */
                        if (timeout > maxtime)
                        {
                                printf("<Waiting for RS232 Input>\n");
                                if (inputBuff[0] == '\0')
                                        return (TIMED_OUT);
                                inputBuff[index++] = '\0';
                                return (DATA_IN);
                        }       /* -- END IF timeout > MAX_TIME ----- */
                        usleep(100);
                        continue;
                }               /* -- END IF ComReady != TRUE  ------ */

                /*temp = WriteString(cntrl_S);*//*Halt Fluke until buffers are empty*/
                while (count > 0)
                {
                if (read(fileno(ReadCom),&ch,1) > 0)
                        {
                         if ( (ch != '\n') && (ch != '\r') )
                                {
                                inputBuff[index++] = ch;
                               /*        printf("%c",ch); */
                                }             /* END IF ch != \n or \r   *********** */
                        }               /* END IF readcom > 0    ******************* */
                count--;
                }               /* ** END WHILE count > 0   ************************ */
                /*temp = WriteString(cntrl_Q);*/ /* allow Fluke to continue sending  */

        };              /* -- END WHILE (1)     ---------------- */

        return (NO_DATA);
}


/* ******************************************************************************** */
/*                    CHECK FOR XOFF DURING WRITE STRING TRANSMISSION               */
/*                                                                                  */
/* ******************************************************************************** */

void check_xon()
{
        int     count;
        char    ch;
        int    control;
        int     timeout;

        /*printf("ReadComString\n"); */   /*    */
        /*printf("Maxtime = %d",MAX_TIME)*/
        count = 0;
        timeout = 0;
        control = FALSE;

        while(1)
        {
                if ((count = ComReady()) < 1)
                        {
                        if (control == FALSE)
                                return;
                if (timeout > 1000)
                        {
                         printf("Writecom timed out waiting for XON\n");
                         return;
                        }
                        timeout++;
                        usleep(50);
                        continue;
                        }               /* -- END IF ComReady != TRUE  ------ */


                while (count > 0)
                {
                if (read(fileno(ReadCom),&ch,1) > 0)
                        {
                         if ( ch == 19 )
                                {
                                control = TRUE;   /* STOP Transmission  */
                                printf("Control 19 Received!!\n");
                                }
                         if ( ch == 17 )
                                control = FALSE;

                        }               /* END IF readcom > 0    ******************* */
                count--;
                }               /* ** END WHILE count > 0   ************************ */

        };              /* -- END WHILE (1)     ---------------- */

        return;
}


/* ******************************************************************************** */
/*          WRITE DATA TO THE COM PORT  (Transmit)                                  */
/* ******************************************************************************** */

int WriteComString(string)
char *string;
{
        /* printf("WriteComString : ");   */   /*   */
        strcat(string,"\r");               /* ** Carriage Return for Fluke Input    */
        check_xon();       /*    */
        while (*string)
        {
                if (dbGetDebugLevel() == 5)
                {
                        /* printf("%c",*string);      */
                        ;
                }

                /* write the characters one at a time                          */
                if (write(fileno(WriteCom),string++,1) != 1)
                {
                        printf("***No char is written to serial port***\n");
                        /* getchar();    */
                        return FALSE;
                }
        } /* ------------ END WHILE (*string) ---------------------------------- */


        /*printf("\n");        */

        return TRUE;
}

/* ******************************************************************************** */
/*          WRITE DATA TO THE COM PORT  (Transmit)                                  */
/* ******************************************************************************** */

int WriteString(string)
char *string;
{
       /*  printf("WriteComString : "); */      /*  */

        while (*string)
        {
                if (dbGetDebugLevel() == 5)
                {
                        printf("%c",*string);
                        ;
                }

                /* write the characters one at a time                          */
                if (write(fileno(WriteCom),string++,1) != 1)
                {
                        printf("***No char is written to serial port***\n");
                        /* getchar();    */
                        return FALSE;
                }
        } /* ------------ END WHILE (*string) ---------------------------------- */


/*      printf("\n"); */      /* */

        return TRUE;
}



/* ******************************************************************************** */
/*             RETURN TRUE IF CHARACTERS ARE AVAILABLE AT THE PORT                  */
/* ******************************************************************************** */
int ComReady()
{
        int     numOfChars;     /* the number of char waiting to be read     */
        numOfChars = 0;
        /* printf("ComReady");    */    /*    */

        /* check the port buffer                                     */
        ioctl(fileno(ReadCom),FIONREAD,&numOfChars);

        if (numOfChars > 0 )
            {
             /*  printf("Char = %d\n");  */
                return (numOfChars);
            }
        else
                return (0);

}

/* ************************************************************************** */
/* int dbGetDebugLevel()                                                      */
/* ************************************************************************** */
int dbGetDebugLevel()
{
        /*  printf("dbGetDebugLevel");   */

        return (7);
}
